% Matlab program to draw phase diagrams in the baseline Diamond overlapping generations model.
% By Marc P. B. Klemp, November 2009.

function f = f(k)
global a b p Prod_type;

if Prod_type == 1                               % This is the CES production function
    f =  a .* (b .* k.^p + (1-b)).^(1./p);
    
elseif Prod_type == 2                           % This is the Cobb-Douglas production function
    f =  a .* k.^b;

elseif Prod_type == 3                           % This is the Cobb-Douglas production function
    f =  b + (a.*k)./(1+k);

end